#!/bin/bash
# vmconfigure-populate.sh
# spins off 5 copies of base vm


# CREATE VMs
for cloaname in nodeNrouter nodeN1 nodeN2 nodeNremote
do
	vboxmanage clonevm fedora31-spring21 --name $cloaname --options=Link --snapshot="base" --register
	vboxmanage modifyvm $cloaname --memory=768
	vboxmanage modifyvm $cloaname --clipboard-mode bidirectional
done

vboxmanage modifyvm nodeN1 --memory=2048
vboxmanage modifyvm nodeN2 --memory=1024

# GROUP VMs
for cloaname in nodeNrouter nodeN1 nodeN2 nodeNremote
do
	vboxmanage modifyvm $cloaname --groups="/NAT"
done

