#!/bin/bash

# vmconfigure-destroy.sh
# destroys VMs - in case you wish to un-do and start over (by re-running vmconfigure-popluate.sh)
#
# You can start over with impunity if need be. VMs can be destroyed (and recreated afresh).
# This script seeks to do the job. If it yields any errors you can do it via command line, for
# an individual VM as:
#    vboxmanage unregistervm --delete <VM>
# Ultimately a VM consists of a set of files and "destroying" amounts to removing the files
# Their default location is in either
#    C:\Users\<username>\VirtualBox VMs  for Windows
# or
#    /home/<username>/VirtualBox VMs     for linux
#
# note the filename contains a space. That's sometimes troublesome in linux. There, when you type
# the name of the file surround it by double-quotes. Purging the files for a given VM within that
# directory erases the VM from VirtualBox's awareness (i.e., destroys).
#

for cloaname in nodeNrouter nodeN1 nodeN2 nodeNremote
do
	# echo Powering $cloaname off
	# vboxManage controlvm $cloaname acpipowerbutton 
	# timeout 2 >nul
	echo Destroying $cloaname
	vboxmanage unregistervm --delete $cloaname
done

