
@ECHO off 

REM Set hostnames within VMs to the same names as used by VirtualBox
REM  (for visual clarity, since hostnames appear in the linux command prompt)
REM This is an internal linux command operation within VMs, so they must be booted first in order to do it
REM But upon booting the VMs are not immediately available for the necessary remote command execution
REM  (executing the linux command to set hostname, from the external host OS, using vboxmanage)
REM therefore a sufficient delay must be inserted. If you don't wait for the VM to "settle" before
REM attempting to set the hostname, doing so fails with error message. This is a persistent
REM linux operation. You only need to do this once, the hostname will remain across future reboots.
REM
REM Set addresses on VMs' interfaces
REM This is an internal linux command operation within VMs, so they must be booted first in order to do it
REM But upon booting the VMs are not immediately available for the necessary remote command execution
REM  (i.e., executing linux's ifconfig command)
REM therefore a sufficient delay must be inserted. If you don't wait for the VM to "settle" before
REM attempting to set addresses, doing so fails with error message. This is not a persistent
REM operation. If you poweroff and reboot you need to apply addresses afresh. 
REM

cls
ECHO.

SET STARTING=0

SET V=node0T
vboxmanage list runningvms | findstr %V% > NUL 
if %ERRORLEVEL% EQU 0 (
	echo %V% already running.
) ELSE (
	SET STARTING=1
	echo Now starting %V%.
	vboxmanage startvm %V%
)

SET V=node1T
vboxmanage list runningvms | findstr %V% > NUL 
if %ERRORLEVEL% EQU 0 (
	echo %V% already running.
 ) ELSE (
	SET STARTING=1
	echo Now starting %V%.
	vboxmanage startvm %V%
)


SET V=node2T
vboxmanage list runningvms | findstr %V% > NUL 
if %ERRORLEVEL% EQU 0 (
	echo %V% already running.
 ) ELSE (
	SET STARTING=1
	echo Now starting %V%.
	vboxmanage startvm %V%
)


SET V=node3T
vboxmanage list runningvms | findstr %V% > NUL 
if %ERRORLEVEL% EQU 0 (
	echo %V% already running.
 ) ELSE (
	SET STARTING=1
	echo Now starting %V%.
	vboxmanage startvm %V%
)


SET V=node4T
vboxmanage list runningvms | findstr %V% > NUL 
if %ERRORLEVEL% EQU 0 (
	echo %V% already running.
 ) ELSE (
	SET STARTING=1
	echo Now starting %V%.
	vboxmanage startvm %V%
)


IF %STARTING% EQU 1 (
	echo.
	echo Pausing 4 minutes for booting to complete before issuing commands.
	echo Please do not interrupt unless you are sure all machines are fully booted.
	timeout 240
)


ECHO.
FOR %%V IN ( node0T node1T node2T node3T node4T
 ) DO (


	echo Setting hostname for %%V using linux/internal command hostnamectl
	REM hostname change is persistent across reboots. Running script and setting hostname multiple times is OK.
	vBoxmanage guestcontrol %%V  --username root --password c$l@bLinuX run --  /usr/bin/hostnamectl set-hostname %%V >nul
)



echo Setting addresses
REM address settings are transient, are not retained across reboots.

vBoxmanage guestcontrol node0T --username root --password c$l@bLinuX run -- /usr/sbin/ifconfig enp0s3 10.2.2.2/24

vBoxmanage guestcontrol node1T --username root --password c$l@bLinuX run -- /usr/sbin/ifconfig enp0s3 10.2.2.1/24
vBoxmanage guestcontrol node1T --username root --password c$l@bLinuX run -- /usr/sbin/ifconfig enp0s8 200.2.2.1/24

vBoxmanage guestcontrol node2T --username root --password c$l@bLinuX run -- /usr/sbin/ifconfig enp0s3 200.2.2.254/24
vBoxmanage guestcontrol node2T --username root --password c$l@bLinuX run -- /usr/sbin/ifconfig enp0s8 100.1.1.254/24

vBoxmanage guestcontrol node3T --username root --password c$l@bLinuX run -- /usr/sbin/ifconfig enp0s3 100.1.1.1/24
vBoxmanage guestcontrol node3T --username root --password c$l@bLinuX run -- /usr/sbin/ifconfig enp0s8 10.1.1.1/24

vBoxmanage guestcontrol node4T --username root --password c$l@bLinuX run -- /usr/sbin/ifconfig enp0s3 10.1.1.2/24


echo Setting routes 
vBoxmanage guestcontrol node4T --username root --password c$l@bLinuX run -- /usr/sbin/route add default gw 10.1.1.1

vBoxmanage guestcontrol node3T --username root --password c$l@bLinuX run -- /usr/sbin/route add -net 200.2.2.0/24 gw 100.1.1.254
vBoxmanage guestcontrol node3T --username root --password c$l@bLinuX run -- /usr/sbin/route add -net  10.2.2.0/24 gw 100.1.1.254

vBoxmanage guestcontrol node2T --username root --password c$l@bLinuX run -- /usr/sbin/route add -net 10.1.1.0/24 gw 100.1.1.1
vBoxmanage guestcontrol node2T --username root --password c$l@bLinuX run -- /usr/sbin/route add -net 10.2.2.0/24 gw 200.2.2.1

vBoxmanage guestcontrol node1T --username root --password c$l@bLinuX run -- /usr/sbin/route add -net 100.1.1.0/24 gw 200.2.2.254
vBoxmanage guestcontrol node1T --username root --password c$l@bLinuX run -- /usr/sbin/route add -net  10.1.1.0/24 gw 200.2.2.254

vBoxmanage guestcontrol node0T --username root --password c$l@bLinuX run -- /usr/sbin/route add default gw 10.2.2.1



echo Turning on forwarding for node1, node2, node3
vBoxmanage guestcontrol node1T --username root --password c$l@bLinuX run -- /usr/bin/sh -c "echo 1 > /proc/sys/net/ipv4/ip_forward"
vBoxmanage guestcontrol node2T --username root --password c$l@bLinuX run -- /usr/bin/sh -c "echo 1 > /proc/sys/net/ipv4/ip_forward"
vBoxmanage guestcontrol node3T --username root --password c$l@bLinuX run -- /usr/bin/sh -c "echo 1 > /proc/sys/net/ipv4/ip_forward"


echo Adding hostnames to /etc/hosts file
FOR %%V IN ( node0T node1T node2T node3T node4T
 ) DO (
vBoxmanage guestcontrol %%V --username root --password c$l@bLinuX run -- /usr/bin/sh -c "echo 10.1.1.2 node4 >> /etc/hosts"
vBoxmanage guestcontrol %%V --username root --password c$l@bLinuX run -- /usr/bin/sh -c "echo 10.1.1.2 node4T >> /etc/hosts"

vBoxmanage guestcontrol %%V --username root --password c$l@bLinuX run -- /usr/bin/sh -c "echo 200.2.2.1 node1 >> /etc/hosts"
vBoxmanage guestcontrol %%V --username root --password c$l@bLinuX run -- /usr/bin/sh -c "echo 200.2.2.1 node1T >> /etc/hosts"

vBoxmanage guestcontrol %%V --username root --password c$l@bLinuX run -- /usr/bin/sh -c "echo 10.1.1.1 node3 >> /etc/hosts"
vBoxmanage guestcontrol %%V --username root --password c$l@bLinuX run -- /usr/bin/sh -c "echo 10.1.1.1 node3T >> /etc/hosts"

vBoxmanage guestcontrol %%V --username root --password c$l@bLinuX run -- /usr/bin/sh -c "echo 10.2.2.2 node0 >> /etc/hosts"
vBoxmanage guestcontrol %%V --username root --password c$l@bLinuX run -- /usr/bin/sh -c "echo 10.2.2.2 node0T >> /etc/hosts"
)


