#!/bin/bash
 

# Set hostnames within VMs to the same names as used by VirtualBox
#  (for visual clarity, since hostnames appear in the linux command prompt)
# This is an internal linux command operation within VMs, so they must be booted first in order to do it
# But upon booting the VMs are not immediately available for the necessary remote command execution
#  (executing the linux command to set hostname, from the external host OS, using vboxmanage)
# therefore a sufficient delay must be inserted. If you don't wait for the VM to "settle" before
# attempting to set the hostname, doing so fails with error message. This is a persistent
# linux operation. You only need to do this once, the hostname will remain across future reboots.
#
# Set addresses on VMs' interfaces
# This is an internal linux command operation within VMs, so they must be booted first in order to do it
# But upon booting the VMs are not immediately available for the necessary remote command execution
#  (i.e., executing linux's ifconfig command)
# therefore a sufficient delay must be inserted. If you don't wait for the VM to "settle" before
# attempting to set addresses, doing so fails with error message. This is not a persistent
# operation. If you poweroff and reboot you need to apply addresses afresh. 
#


function countdown
{
cnt=$1
while [ $cnt -gt 0 ]
do
	echo -ne  "counting down: $cnt\033[0K\r"
	sleep 1
	let cnt--
	read -n 1 -s -t 0.1 input
	if [[ $input = "q" ]]
	then
		break
	fi

done
}



clear
echo

starting=0

V=node0T
if vboxmanage list runningvms | grep $V > /dev/null 
then
#if %ERRORLEVEL% EQU 0 (
	echo $V already running.
else
	starting=1
	echo Now starting $V.
	vboxmanage startvm $V
fi

V=node1T
if vboxmanage list runningvms | grep $V > /dev/null 
then
#if %ERRORLEVEL% EQU 0 (
	echo $V already running.
else
	starting=1
	echo Now starting $V.
	vboxmanage startvm $V
fi


V=node2T
if vboxmanage list runningvms | grep $V > /dev/null 
then
#if %ERRORLEVEL% EQU 0 (
	echo $V already running.
else
	starting=1
	echo Now starting $V.
	vboxmanage startvm $V
fi


V=node3T
if vboxmanage list runningvms | grep $V > /dev/null 
then
#if %ERRORLEVEL% EQU 0 (
	echo $V already running.
else
	starting=1
	echo Now starting $V.
	vboxmanage startvm $V
fi


V=node4T
if vboxmanage list runningvms | grep $V > /dev/null 
then
#if %ERRORLEVEL% EQU 0 (
	echo $V already running.
else
	starting=1
	echo Now starting $V.
	vboxmanage startvm $V
fi


if [ "$starting" = 1 ] 
then
	echo
	echo Pausing 10 minutes for booting to complete before issuing commands.
	echo Please do not interrupt \(q key\) unless you are sure all machines are fully booted.
	countdown 600
fi


# put the guest user's password in a file on host for consumption of   vboxmanage guestcontrol
passfile=$(mktemp)
echo -n 'c$l@bLinuX' > $passfile




echo
for cloaname in node0T node1T node2T node3T node4T
do


	echo Setting hostname for $cloaname using linux/internal command hostnamectl
	# hostname change is persistent across reboots. Running script and setting hostname multiple times is OK.
	vboxmanage guestcontrol $cloaname  --username root --passwordfile $passfile run --  /usr/bin/hostnamectl set-hostname $cloaname >nul
done



echo Setting addresses
# address settings are transient, are not retained across reboots.

vboxmanage guestcontrol node0T --username root --passwordfile $passfile run -- /usr/sbin/ifconfig enp0s3 10.2.2.2/24

vboxmanage guestcontrol node1T --username root --passwordfile $passfile run -- /usr/sbin/ifconfig enp0s3 10.2.2.1/24
vboxmanage guestcontrol node1T --username root --passwordfile $passfile run -- /usr/sbin/ifconfig enp0s8 200.2.2.1/24

vboxmanage guestcontrol node2T --username root --passwordfile $passfile run -- /usr/sbin/ifconfig enp0s3 200.2.2.254/24
vboxmanage guestcontrol node2T --username root --passwordfile $passfile run -- /usr/sbin/ifconfig enp0s8 100.1.1.254/24

vboxmanage guestcontrol node3T --username root --passwordfile $passfile run -- /usr/sbin/ifconfig enp0s3 100.1.1.1/24
vboxmanage guestcontrol node3T --username root --passwordfile $passfile run -- /usr/sbin/ifconfig enp0s8 10.1.1.1/24

vboxmanage guestcontrol node4T --username root --passwordfile $passfile run -- /usr/sbin/ifconfig enp0s3 10.1.1.2/24


echo Setting routes 
vboxmanage guestcontrol node4T --username root --passwordfile $passfile run -- /usr/sbin/route add default gw 10.1.1.1

vboxmanage guestcontrol node3T --username root --passwordfile $passfile run -- /usr/sbin/route add -net 200.2.2.0/24 gw 100.1.1.254
vboxmanage guestcontrol node3T --username root --passwordfile $passfile run -- /usr/sbin/route add -net  10.2.2.0/24 gw 100.1.1.254

vboxmanage guestcontrol node2T --username root --passwordfile $passfile run -- /usr/sbin/route add -net 10.1.1.0/24 gw 100.1.1.1
vboxmanage guestcontrol node2T --username root --passwordfile $passfile run -- /usr/sbin/route add -net 10.2.2.0/24 gw 200.2.2.1

vboxmanage guestcontrol node1T --username root --passwordfile $passfile run -- /usr/sbin/route add -net 100.1.1.0/24 gw 200.2.2.254
vboxmanage guestcontrol node1T --username root --passwordfile $passfile run -- /usr/sbin/route add -net  10.1.1.0/24 gw 200.2.2.254

vboxmanage guestcontrol node0T --username root --passwordfile $passfile run -- /usr/sbin/route add default gw 10.2.2.1



echo Turning on forwarding for node1, node2, node3
vboxmanage guestcontrol node1T --username root --passwordfile $passfile run -- /usr/bin/sh -c "echo 1 > /proc/sys/net/ipv4/ip_forward"
vboxmanage guestcontrol node2T --username root --passwordfile $passfile run -- /usr/bin/sh -c "echo 1 > /proc/sys/net/ipv4/ip_forward"
vboxmanage guestcontrol node3T --username root --passwordfile $passfile run -- /usr/bin/sh -c "echo 1 > /proc/sys/net/ipv4/ip_forward"


echo Adding hostnames to /etc/hosts file
for cloaname in node0T node1T node2T node3T node4T
do
vboxmanage guestcontrol $cloaname --username root --passwordfile $passfile run -- /usr/bin/sh -c "echo 10.1.1.2 node4 >> /etc/hosts"
vboxmanage guestcontrol $cloaname --username root --passwordfile $passfile run -- /usr/bin/sh -c "echo 10.1.1.2 node4T >> /etc/hosts"

vboxmanage guestcontrol $cloaname --username root --passwordfile $passfile run -- /usr/bin/sh -c "echo 200.2.2.1 node1 >> /etc/hosts"
vboxmanage guestcontrol $cloaname --username root --passwordfile $passfile run -- /usr/bin/sh -c "echo 200.2.2.1 node1T >> /etc/hosts"

vboxmanage guestcontrol $cloaname --username root --passwordfile $passfile run -- /usr/bin/sh -c "echo 10.1.1.1 node3 >> /etc/hosts"
vboxmanage guestcontrol $cloaname --username root --passwordfile $passfile run -- /usr/bin/sh -c "echo 10.1.1.1 node3T >> /etc/hosts"

vboxmanage guestcontrol $cloaname --username root --passwordfile $passfile run -- /usr/bin/sh -c "echo 10.2.2.2 node0 >> /etc/hosts"
vboxmanage guestcontrol $cloaname --username root --passwordfile $passfile run -- /usr/bin/sh -c "echo 10.2.2.2 node0T >> /etc/hosts"
done


