
@ECHO off 

REM Set hostnames within VMs to the same names as used by VirtualBox
REM  (for visual clarity, since hostnames appear in the linux command prompt)
REM This is an internal linux command operation within VMs, so they must be booted first in order to do it
REM But upon booting the VMs are not immediately available for the necessary remote command execution
REM  (executing the linux command to set hostname, from the external host OS, using vboxmanage)
REM therefore a sufficient delay must be inserted. If you don't wait for the VM to "settle" before
REM attempting to set the hostname, doing so fails with error message. This is a persistent
REM linux operation. You only need to do this once, the hostname will remain across future reboots.
REM
REM Set addresses on VMs' interfaces
REM This is an internal linux command operation within VMs, so they must be booted first in order to do it
REM But upon booting the VMs are not immediately available for the necessary remote command execution
REM  (i.e., executing linux's ifconfig command)
REM therefore a sufficient delay must be inserted. If you don't wait for the VM to "settle" before
REM attempting to set addresses, doing so fails with error message. This is not a persistent
REM operation. If you poweroff and reboot you need to apply addresses afresh. 
REM

cls
ECHO.

SET STARTING=0

SET V=middleB
vboxmanage list runningvms | findstr %V% > NUL 
if %ERRORLEVEL% EQU 0 (
	echo %V% already running.
) ELSE (
	SET STARTING=1
	echo Now starting %V%.
	vboxmanage startvm %V%
)

SET V=leftB
vboxmanage list runningvms | findstr %V% > NUL 
if %ERRORLEVEL% EQU 0 (
	echo %V% already running.
 ) ELSE (
	SET STARTING=1
	echo Now starting %V%.
	vboxmanage startvm %V%
)

SET V=rightB
vboxmanage list runningvms | findstr %V% > NUL 
if %ERRORLEVEL% EQU 0 (
	echo %V% already running.
 ) ELSE (
	SET STARTING=1
	echo Now starting %V%.
	vboxmanage startvm %V%
)


IF %STARTING% EQU 1 (
	echo.
	echo Pausing 4 minutes for booting to complete before issuing commands.
	echo Please do not interrupt unless you are sure all machines are fully booted.
	timeout 240
)


ECHO.
FOR %%V IN ( middleB leftB rightB
 ) DO (


	echo Setting hostname for %%V using linux/internal command hostnamectl
	REM hostname change is persistent across reboots. Running script and setting hostname multiple times is OK.
	vBoxmanage guestcontrol %%V  --username root --password c$l@bLinuX run --  /usr/bin/hostnamectl set-hostname %%V >nul
)



REM network settings are transient, are not retained across reboots.
echo Setting addresses for interfaces of the 4 nodes that are connected to main network N1 

vBoxmanage guestcontrol middleB --username root --password c$l@bLinuX run -- /usr/sbin/ifconfig enp0s3 200.2.2.151/24
vBoxmanage guestcontrol leftB --username root --password c$l@bLinuX run -- /usr/sbin/ifconfig enp0s3 200.2.2.150/24

echo Setting addresses for interfaces of the 2 nodes that are connected to outlier network N2 
vBoxmanage guestcontrol middleB --username root --password c$l@bLinuX run -- /usr/sbin/ifconfig enp0s8 192.168.3.1/24
vBoxmanage guestcontrol rightB --username root --password c$l@bLinuX run -- /usr/sbin/ifconfig enp0s3 192.168.3.2/24

echo Setting route tables for inter-LAN gatewayed access 
vBoxmanage guestcontrol leftB --username root --password c$l@bLinuX run -- /usr/sbin/route add -net 192.168.3.0/24 gw 200.2.2.151 
vBoxmanage guestcontrol rightB --username root --password c$l@bLinuX run -- /usr/sbin/route add -net 200.2.2.0/24 gw 192.168.3.1 

echo Turning on forwarding for leftB and middleB 
vBoxmanage guestcontrol middleB --username root --password c$l@bLinuX run -- /usr/bin/sh -c "echo 1 > /proc/sys/net/ipv4/ip_forward"
vBoxmanage guestcontrol leftB --username root --password c$l@bLinuX run -- /usr/bin/sh -c "echo 1 > /proc/sys/net/ipv4/ip_forward"

