#!/bin/bash
 

# Set hostnames within VMs to the same names as used by VirtualBox
#  (for visual clarity, since hostnames appear in the linux command prompt)
# This is an internal linux command operation within VMs, so they must be booted first in order to do it
# But upon booting the VMs are not immediately available for the necessary remote command execution
#  (executing the linux command to set hostname, from the external host OS, using vboxmanage)
# therefore a sufficient delay must be inserted. If you don't wait for the VM to "settle" before
# attempting to set the hostname, doing so fails with error message. This is a persistent
# linux operation. You only need to do this once, the hostname will remain across future reboots.
#
# Set addresses on VMs' interfaces
# This is an internal linux command operation within VMs, so they must be booted first in order to do it
# But upon booting the VMs are not immediately available for the necessary remote command execution
#  (i.e., executing linux's ifconfig command)
# therefore a sufficient delay must be inserted. If you don't wait for the VM to "settle" before
# attempting to set addresses, doing so fails with error message. This is not a persistent
# operation. If you poweroff and reboot you need to apply addresses afresh. 
#



function countdown
{
cnt=$1
while [ $cnt -gt 0 ]
do
	echo -ne  "counting down: $cnt\033[0K\r"
	sleep 1
	let cnt--
	read -n 1 -s -t 0.1 input
	if [[ $input = "q" ]]
	then
		break
	fi

done
}



clear
echo

starting=0

V=middleB
if vboxmanage list runningvms | grep $V > /dev/null 
then
	echo $V already running.
else
	starting=1
	echo Now starting $V.
	vboxmanage startvm $V 
fi

V=leftB
if vboxmanage list runningvms | grep $V > /dev/null 
then
	echo $V already running.
else
	starting=1
	echo Now starting $V.
	vboxmanage startvm $V 
fi

V=rightB
if vboxmanage list runningvms | grep $V > /dev/null 
then
	echo $V already running.
else
	starting=1
	echo Now starting $V.
	vboxmanage startvm $V 
fi


if [ "$starting" = 1 ] 
then
	echo
	echo Pausing 5 minutes for booting to complete before issuing commands.
	echo Please do not interrupt \(q key\) unless you are sure all machines are fully booted.
	countdown 300
fi


# put the guest user's password in a file on host for consumption of   vboxmanage guestcontrol
passfile=$(mktemp)
echo -n 'c$l@bLinuX' > $passfile


echo

for cloaname in middleB leftB rightB
do


	echo Setting hostname for $cloaname using linux/internal command hostnamectl
	# hostname change is persistent across reboots. Running script and setting hostname multiple times is OK.
	vboxmanage guestcontrol $cloaname  --username root --passwordfile $passfile  run --  /usr/bin/hostnamectl set-hostname $cloaname >nul
done



# network settings are transient, are not retained across reboots.
echo Setting addresses for interfaces of the 4 nodes that are connected to main network N1 

vboxmanage guestcontrol middleB --username root --passwordfile $passfile  run -- /usr/sbin/ifconfig enp0s3 200.2.2.151/24
vboxmanage guestcontrol leftB --username root --passwordfile $passfile  run -- /usr/sbin/ifconfig enp0s3 200.2.2.150/24

echo Setting addresses for interfaces of the 2 nodes that are connected to outlier network N2 
vboxmanage guestcontrol middleB --username root --passwordfile $passfile  run -- /usr/sbin/ifconfig enp0s8 192.168.3.1/24
vboxmanage guestcontrol rightB --username root --passwordfile $passfile  run -- /usr/sbin/ifconfig enp0s3 192.168.3.2/24

echo Setting route tables for inter-LAN gatewayed access 
vboxmanage guestcontrol leftB --username root --passwordfile $passfile  run -- /usr/sbin/route add -net 192.168.3.0/24 gw 200.2.2.151 
vboxmanage guestcontrol rightB --username root --passwordfile $passfile  run -- /usr/sbin/route add -net 200.2.2.0/24 gw 192.168.3.1 

echo Turning on forwarding for leftB and middleB 
vboxmanage guestcontrol middleB --username root --passwordfile $passfile  run -- /usr/bin/sh -c "echo 1 > /proc/sys/net/ipv4/ip_forward"
vboxmanage guestcontrol leftB --username root --passwordfile $passfile  run -- /usr/bin/sh -c "echo 1 > /proc/sys/net/ipv4/ip_forward"

