
REM vmconfigure-destroy.bat
REM destroys VMs - in case you wish to un-do and start over (by re-running vmconfigure.bat)
REM
REM You can start over with impunity if need be. VMs can be destroyed (and recreated afresh).
REM This script seeks to do the job. If it yields any errors you can do it via command line, for
REM an individual VM as:
REM    vboxmanage unregistervm --delete <VM>
REM Ultimately a VM consists of a set of files and "destroying" amounts to removing the files
REM Their default location is in either
REM    C:\Users\<username>\VirtualBox VMs  for Windows
REM or
REM    /home/<username>/VirtualBox VMs     for linux
REM
REM note the filename contains a space. That's sometimes troublesome in linux. There, when you type
REM the name of the file surround it by double-quotes. Purging the files for a given VM within that
REM directory erases the VM from VirtualBox's awareness (i.e., destroys).
REM

%ECHO off

FOR %%V IN ( Router-1 Router-2 Router-3 Router-4 PC-1 PC-2 PC-3 PC-4 ) DO (
	echo Powering %%V off
	vboxManage controlvm %%V acpipowerbutton 
	timeout 2 >nul
	echo Destroying %%V
	vboxmanage unregistervm --delete %%V
)

