#!/bin/bash

# vmconfigure-destroy.sh
# destroys VMs - in case you wish to un-do and start over (by re-running vmconfigure.bat)
#
# You can start over with impunity if need be. VMs can be destroyed (and recreated afresh).
# This script seeks to do the job. If it yields any errors you can do it via command line, for
# an individual VM as:
#    vboxmanage unregistervm --delete <VM>
# Ultimately a VM consists of a set of files and "destroying" amounts to removing the files
# Their default location is in either
#    C:\Users\<username>\VirtualBox VMs  for Windows
# or
#    /home/<username>/VirtualBox VMs     for linux
#
# note the filename contains a space. That's sometimes troublesome in linux. There, when you type
# the name of the file surround it by double-quotes. Purging the files for a given VM within that
# directory erases the VM from VirtualBox's awareness (i.e., destroys).
#

for cloaname in Router-1 Router-2 Router-3 Router-4 PC-1 PC-2 PC-3 PC-4
do
	echo Powering $cloaname off
	vboxmanage controlvm $cloaname acpipowerbutton
	sleep 2
	echo Destroying $cloaname
	vboxmanage unregistervm --delete $cloaname
done

